//---------------------------------------------------------------
// Fichero:  demostracion.asy
// Objetivo: Mostrar la idea de la demostración
// Fecha:    S.24.5.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Dimensiones de los ejes
real Xmin = 0, Xmax = 6, Ymin = 0, Ymax = 3.25, Extra = 0.25;

// Grosor de las líneas
defaultpen(1);

// El eje de ordenadas
draw((0,Ymin-Extra) -- (0,Ymax+Extra), gray);

// El eje de abscisas
draw((Xmin-Extra,0) -- (Xmax+Extra,0), gray);

// La gráfica
pair A=(1,1), B=(5,3);
pair V=B-A;
draw(A+1.2*V -- B-1.3*V);

// Los incrementos
pair C=(5,1);
draw(A -- C -- B,heavygreen);

// Dos puntos
label("H$_{1}$",A,NW);
label("H$_{2}$",B,NW);

// La separación entre las flechas y el objeto
real Separacion = 0.25;

// Las flechas que marcan los incrementos
draw(A-(0,Separacion) -- C-(0,Separacion), 0.75bp+blue, Bars(1.5mm));
draw(C+(Separacion,0) -- B+(Separacion,0), 0.75bp+blue, Bars(1.5mm));

// Los valores
label("x$_{2}-$x$_{1}$", (A+C)/2-(0,2*Separacion), fontsize(8pt));
label("y$_{2}-$y$_{1}$", (C+B)/2+(4*Separacion,0), fontsize(8pt));

// Las marcas de los ejes
draw((A.x,0.05)--(A.x,-0.05),1pt+blue);
label("x$_{1}$",(A.x,0),S);
draw((B.x,0.05)--(B.x,-0.05),1pt+blue);
label("x$_{2}$",(B.x,0),S);
draw((0.05,A.y)--(-0.05,A.y),1pt+blue);
label("y$_{1}$",(0,A.y),W);
draw((0.05,B.y)--(-0.05,B.y),1pt+blue);
label("y$_{2}$",(0,B.y),W);

// El vector de dirección
dot(A, 3bp+deepgreen);
dot(B, 3bp+deepgreen);
draw(A -- B, 1bp+deepgreen,Arrow(HookHead,5pt));
pair Pos=(A+B)/2+0.5NW;
label("H$_1$H$_2$",Pos,fontsize(8pt));
draw(Pos+(-0.35,0.25) -- Pos+(0.35,0.25), 0.5bp+black,Arrow(HookHead,1.5pt));
