//---------------------------------------------------------------
// Fichero:  ordenadaorigen.asy
// Objetivo: Representar la ordenada en el origen de una recta
// Fecha:    D.11.5.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3cm);

// Grosor de las líneas
defaultpen(1);

// Los ejes de coordenadas
real Xmin = -2, Xmax = 6, Ymin = 0, Ymax = 3, Extra = 0.25;
draw((Xmin-Extra,0) -- (Xmax+Extra,0));
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// La recta
pair Q=(0,1.5), v=(4,1);
draw(Q-0.5v -- Q+1.5v, 1.5bp+blue);
label("r",(2.5,2.5),fontsize(8pt));

// La ordenada en el origen
dot(Q, 3bp+deepgreen);
label("(0,q)",Q,NW,fontsize(6pt));
