//---------------------------------------------------------------
// Fichero:  vr.asy
// Objetivo: Representar el vector de dirección de una recta
// Fecha:    S.10.5.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3cm);

// Grosor de las líneas
defaultpen(1);

// Los ejes de coordenadas
real Xmin = -1, Xmax = 5, Ymin = -1, Ymax = 3, Extra = 0.25;
draw((Xmin-Extra,0) -- (Xmax+Extra,0));
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// La recta
draw((-1,0.5) -- (5,3), 1.5bp+blue);
label("r",(2.5,2.5),fontsize(12pt));

// El vector de dirección
dot((0,0), 3bp+deepgreen);
pair F=0.4*(6,2.5);
draw((0,0) -- F, 1.25bp+deepgreen,Arrow(HookHead,5pt));
label("$\vec{v}_r$",1.2F,deepgreen+fontsize(12pt));
