//---------------------------------------------------------------
// Fichero:  inclinado.asy
// Objetivo: Representar un plano inclinado
// Fecha:    D.13.4.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(10cm);

// Grosor de las líneas
defaultpen(1);

// El triángulo
int Alt=4, Long=8;
real Ang=-aTan(Alt/Long);
draw((0,0) -- (Long,0) -- (0,Alt) -- (0,0));

// El objeto
path Objeto=box((0,0),(1,0.5));
pair Base=(1,Alt-Alt/Long);
filldraw(shift(Base)*rotate(Ang)*Objeto,gray,black);

// Los vectores
pair A=shift(Base)*rotate(Ang)*(0,0);
pair B=shift(Base)*rotate(Ang)*(1,0.5);
pair Origen=(A+B)/2;
real Modulo=3;
draw(Origen -- Origen+(0,-Modulo), 1.25bp+deepred,Arrow(HookHead,5pt));
draw(Origen -- Origen-Sin(Ang)*Modulo*(Cos(Ang),Sin(Ang)),
     1.25bp+deepgreen,Arrow(HookHead,5pt));
draw(Origen -- Origen+Cos(Ang)*Modulo*(Sin(Ang),-Cos(Ang)),
     1.25bp+deepgreen,Arrow(HookHead,5pt));
dot(Origen, 6bp+deepgreen);
dot(Origen, 3bp+deepred);
