//---------------------------------------------------------------
// Fichero:  triangulo1.asy
// Objetivo: Representar el triángulo del vector del primer cuadrante
// Fecha:    X.9.4.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.4cm);

// Grosor de las líneas
defaultpen(1);

// El vector
pair v=(3,2);

// Los vértices del triángulo
pair A=(0,0), B=(v.x,0), C=v;

// Elo ángulo recto
markrightangle(C, B, A, 4mm, 0.75bp+gray);

// El triángulo
draw(A -- B -- C -- A);

// Los nombres de los lados
pen FormatoTexto = blue+fontsize(10pt);
label("$|v_{1}|$",B/2,S,FormatoTexto);
label("$|v_{2}|$",(B+C)/2,E,FormatoTexto);
label("$|\vec{v}|$",C/2,NW,FormatoTexto);
