//---------------------------------------------------------------
// Fichero:  figura1.asy
// Objetivo: Representar vectores equivalentes
// Fecha:    M.8.4.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// Dimensiones de los ejes
real Xmin = 0, Xmax = 9, Ymin = 0, Ymax = 5, Extra = 0.25;

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(8pt);

// Rectas paralelas
pen FormatoRecta = gray+0.5bp;
pair A=(0,4), B=(4/3,5), Sep=(0.2,0.15);
draw(A+Sep -- B, FormatoRecta);
pair A=(0,3), B=(8/3,5);
draw(A+Sep -- B, FormatoRecta);
pair A=(0,0.25), B=(19/3,5);
draw(A+Sep -- B, FormatoRecta);
pair A=(1.5,0), B=(49/6,5);
draw(A+Sep -- B, FormatoRecta);
pair A=(6,0), B=(9,2.25);
draw(A+Sep -- B, FormatoRecta);
pair A=(8,0), B=(9,0.75);
draw(A+Sep -- B, FormatoRecta);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// Los vectores
dot((1,2), 4bp+deepgreen);
draw((1,2)--(5,5), 1.5bp+deepgreen,Arrow(HookHead,5pt));
dot((5,1), 4bp+deepgreen);
draw((5,1)--(9,4), 1.5bp+deepgreen,Arrow(HookHead,5pt));

// Los nombres de los vectores
pen FormatoTexto = blue+fontsize(12pt);
label("$\vec{u}$",(3,3.5),NW,FormatoTexto);
label("$\vec{v}$",(7,2.5),NW,FormatoTexto);
