//---------------------------------------------------------------
// Fichero:  varignon.asy
// Objetivo: Ayudar a entender el teorema de Varignon
// Fecha:    D.6.7.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// grid()
import math;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,4.3cm);

// Dimensiones de los ejes
int Xmin = -20, Xmax = 20, Ymin = -10, Ymax = 10;
real Extra = 0.25;

// Rejilla de ayuda
add(shift(Xmin,Ymin)*grid((int)(Xmax-Xmin),(int)(Ymax-Ymin),0.5bp+gray));

// Los puntos de la rejilla
for ( int i=Xmin ; i<= Xmax ; ++i ) {
for ( int j=Ymin ; j<= Ymax ; ++j ) {
    dot((i,j),1bp+black);
    }}

// Grosor de las líneas
defaultpen(1);

// Los ejes
draw((0,Ymin-Extra) -- (0,Ymax+Extra));
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// Las zonas
path Zona=box((-2.5,-1.5),(2.5,1.5));
draw(shift(17,8)*Zona,1bp+blue);
draw(shift(-14,5)*Zona,1bp+blue);
draw(shift(-9,-5)*Zona,1bp+blue);
draw(shift(7,-8)*Zona,1bp+blue);

// Los nombres
path Fondo=scale(0.9)*unitcircle;
pen FormatoTexto=Helvetica(series="b",shape="n")+fontsize(10pt)+blue;
fill(shift(19,5)*Fondo,white);
fill(shift(11,-9)*Fondo,white);
fill(shift(-13,-7)*Fondo,white);
fill(shift(-18,8)*Fondo,white);
label("A",(19,5),FormatoTexto);
label("B",(11,-9),FormatoTexto);
label("C",(-13,-7),FormatoTexto);
label("D",(-18,8),FormatoTexto);
