//---------------------------------------------------------------
// Fichero:  enunciado1izq.asy
// Objetivo: Mostrar la ilustración izquierda del enunciado 1
// Fecha:    M.10.6.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1.25);

// Los puntos
pair A=(0,0), B=(5,0), C=(5,5), D=(0,3), E=(8,0), F=(8,8), G=(5,8), H=(0,8);

// Las piezas
path P1 = A -- B -- C -- D -- cycle;
path P2 = D -- C -- G -- H -- cycle;
path P3 = B -- E -- G -- cycle;
path P4 = G -- F -- E -- cycle;
fill(P1,mediumred);
fill(P2,mediumgreen);
fill(P3,mediumblue);
fill(P4,mediummagenta);

// La rejilla
add(grid(8,8,1bp+white));

// Las piezas
draw(P1);
draw(P2);
draw(P3);
draw(P4);

// Los nombres de las piezas
pen FormatoTexto=Helvetica(series="m",shape="n")+fontsize(20pt);
pen ColorFondo=lightgray;
real r=0.4;

pair pos=(2.5,6);
fill(circle(pos,r),ColorFondo);
label("A",pos,FormatoTexto);

pair pos=(2.5,2);
fill(circle(pos,r),ColorFondo);
label("B",pos,FormatoTexto);

pair pos=(7,6);
fill(circle(pos,r),ColorFondo);
label("C",pos,FormatoTexto);

pair pos=(6,2);
fill(circle(pos,r),ColorFondo);
label("D",pos,FormatoTexto);
