//---------------------------------------------------------------
// Fichero:  euler.asy
// Objetivo: Representar la recta de Euler
// Fecha:    X.25.6.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
include fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Grosor de las líneas
defaultpen(1);

// El triángulo
pair A=(0,0), B=(168,24), C=(42,42);
draw(A -- B -- C -- cycle);

// Los centros
pair T=(93,-51), G=(70,22), H=(24,168), I=(48,24);

// La recta de Euler
draw(T -- H, blue);

// Marcamos los puntos
pen FormatoPunto=3bp+black;
pen FormatoTexto=black+fontsize(10pt);
dot(A,FormatoPunto);
dot(B,FormatoPunto);
dot(C,FormatoPunto);
label("A",A,W,FormatoTexto);
label("B",B,E,FormatoTexto);
label("C",C,NW,FormatoTexto);
pen FormatoPunto=3bp+deepgreen;
dot(T,FormatoPunto);
dot(G,FormatoPunto);
dot(H,FormatoPunto);
dot(I,FormatoPunto);
label("T",T,E,FormatoTexto);
label("G",G,E,FormatoTexto);
label("H",H,W,FormatoTexto);
label("I",I,W,FormatoTexto);
