//---------------------------------------------------------------
// Fichero:  dori.asy
// Objetivo: Representar el dado de Dori
// Fecha:    M.19.8.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
include fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.5cm);

// Grosor de las líneas
defaultpen(1);

// Formato del texto
pen Formato=fontsize(24pt)+Helvetica(series="b",shape="n");

// El cuadrado básico
path Cuadrado=unitsquare;

// Los seis cuadrados
for ( int i=0 ; i<4 ; ++i )
    { draw(shift(i,0)*Cuadrado); }
draw(shift(2,1)*Cuadrado);
draw(shift(1,-1)*Cuadrado);

// El nombre
label("Dori",(1,1.5),Formato);

// El formato de los puntos
pen FP=black+5bp;

// Función que dibuja cinco puntos
void Dibuja5(pair P)
    {
    transform Mov=shift(P+(0.5,0.5));
    dot(Mov*(0,0),FP);
    dot(Mov*(0.25,0.25),FP);
    dot(Mov*(0.25,-0.25),FP);
    dot(Mov*(-0.25,0.25),FP);
    dot(Mov*(-0.25,-0.25),FP);
    }

// Función que dibuja tres puntos
void Dibuja3(pair P)
    {
    transform Mov=shift(P+(0.5,0.5));
    dot(Mov*(0,0),FP);
    dot(Mov*(0.25,0.25),FP);
    dot(Mov*(-0.25,-0.25),FP);
    }

// Función que dibuja siete puntos
void Dibuja7(pair P)
    {
    transform Mov=shift(P+(0.5,0.5));
    dot(Mov*(0,0),FP);
    dot(Mov*(0,0.3),FP);
    dot(Mov*(0.3,0),FP);
    dot(Mov*(-0.3,0),FP);
    dot(Mov*(-0.3,-0.3),FP);
    dot(Mov*(0,-0.3),FP);
    dot(Mov*(0.3,-0.3),FP);
    }

// Los puntos
Dibuja5((1,-1));
Dibuja5((2,1));
Dibuja7((1,0));
Dibuja7((2,0));
Dibuja3((3,0));
Dibuja3((0,0));
