//---------------------------------------------------------------
// Fichero:  resolucion3.asy
// Objetivo: Representar la resolución 3
// Fecha:    S.17.2.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
include fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8.8cm);

// Grosor de las líneas
defaultpen(1);

// La elipse general
path Elipse=scale(4,3)*unitcircle;

// Formato del texto
pen Formato=fontsize(18pt)+Bookman(series="b",shape="n");

// Los conjuntos
real SepH=3.5, SepV=3;
draw(shift(-SepH/2,0)*Elipse);
draw(shift(SepH/2,0)*Elipse);
draw(shift(0,-SepV)*Elipse);
label("A",(-4.8,2.3),NW,Formato);
label("B",(4.8,2.3),NE,Formato);
label("C",(3.8,-5.2),NE,Formato);

// Los elementos
label("d",(-3.5,1.3),Formato);
label("e",(-4,-0.5),Formato);
label("h",(-2.5,-1.8),Formato);
label("f",(0,1.3),Formato);
label("g",(0,-1.3),Formato);
label("i",(3.5,1.3),Formato);
label("j",(4,-0.5),Formato);
label("k",(2.5,-1.8),Formato);
label("m",(-1.5,-4.3),Formato);
label("n",(1.5,-4.3),Formato);
