#!/usr/bin/python
# coding: utf-8

#--------------------------------------------------------------------
# Fichero:  posibilidades.py
# Objetivo: Calcula todas las posibilidades
# Autor:    Pedro Reina <pedro@pedroreina.net>
# Fecha:    M.20.8.2024
# Atención: solo se ha probado en Python 2.7
# Licencia: Dominio público
#           https://creativecommons.org/publicdomain/zero/1.0/
#--------------------------------------------------------------------

#------------------------------------------------
# Datos
#------------------------------------------------

# Las opciones de elección de sexo
# M: masculino, F: femenino
Opciones = ('MMFF', 'MFMF', 'MFFM', 'FMMF', 'FMFM', 'FFMM')

# Los records de cada sexo. Espalda, braza, mariposa y libre
Record = {
    'M': ('51,60', '56,88', '49,45', '46,40'),
    'F': ('57,13', '1:04,13', '55,18', '51,71')
    }

# Los símbolos de masculino y femenino
Simbolo = {'M': '♂', 'F': '♀'}

#------------------------------------------------
# El programa
#------------------------------------------------

# Convertimos los records en segundos
Segundos = {
    'M': [0, 0, 0, 0],
    'F': [0, 0, 0, 0]
    }
for Sexo in ('M','F'):
    for Estilo in range(4):
        Texto = Record[Sexo][Estilo]
        if ':' in Texto:
            Datos = Texto.split(':')
            Minuto = int(Datos[0])
            Resto = Datos[1]
        else:
            Minuto = 0
            Resto = Texto
        SegCen = Resto.split(',')
        Segundo = int(SegCen[0])
        Centesima = int(SegCen[1])
        Tiempo = 60*Minuto + Segundo + Centesima/100.0
        Segundos[Sexo][Estilo] = Tiempo

# Calculamos todas las opciones
for Opcion in Opciones:
    # La descripción con símbolos de esta opción
    Descripcion = ''
    for Sexo in range(4):
        Descripcion += Simbolo[Opcion[Sexo]]

    # El texto con la suma de tiempos
    Lista = [Record[Opcion[Estilo]][Estilo] for Estilo in range(4)]
    TextoSuma = ' + '.join(Lista)

    # El tiempo total, en segundos
    Tiempo = sum(Segundos[Opcion[Estilo]][Estilo] for Estilo in range(4))
    TiempoEsp = str(Tiempo).replace('.',',')

    # Cambiamos el formato del tiempo
    Entera = int(Tiempo)
    Decimal = int(round(100*(Tiempo-Entera),0))
    Minuto = Entera/60
    Segundo = Entera - 60*Minuto
    TiempoNat = str(Minuto) + ':' + str(Segundo) + ',' + str(Decimal).zfill(2)

    # Imprimimos la opción
    print Descripcion, '→', TextoSuma, '=', TiempoEsp, '=', TiempoNat
