//---------------------------------------------------------------
// Fichero:  bandera.asy
// Objetivo: Dar varios ejemplos de bandera
// Fecha:    D.7.4.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(17cm);

// Función que devuelve un color aleatorio
pen Color()
    {
    pen[] Posible={blue, yellow, heavygreen, red, black, purple, cyan};
    return Posible[floor(Posible.length*unitrand())];
    }

// Dimensiones
int Anchura=5, Altura=3;

// Iniciamos el generador de números aleatorios
srand(5);

// Las banderas
int Base=0;
for ( int i=0 ; i<10 ; ++i )
    {
    Base += Anchura+1;
    // Los rectángulos
    fill(box((Base,0),(Base+Anchura,Altura/3)),Color());
    fill(box((Base,Altura/3),(Base+Anchura,2*Altura/3)),Color());
    fill(box((Base,2*Altura/3),(Base+Anchura,Altura)),Color());
    }
