//---------------------------------------------------------------
// Fichero:  depositos.asy
// Objetivo: Representar depósitos hexagonales
// Fecha:    V.15.3.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3cm);

// Grosor de las líneas
defaultpen(0.75);

// El hexágono regular básico
path Hexagono=rotate(30)*polygon(6);

// Desplazamientos
real DespHor=sqrt(3);
real DespVer=1.5;

// Repetimos el hexágono
for ( int Fil=-5 ; Fil<6 ; ++Fil )
    {
    for ( int Col=-5 ; Col<6-abs(Fil) ; ++Col )
        {
        real Avance=(Col+quotient(abs(Fil),2))*DespHor+(Fil%2)*DespHor/2;
        draw(shift(Avance,Fil*DespVer)*Hexagono);
        }
    }

// Resaltamos algunas uniones
path Segmento=(0.5,0)--(DespHor-0.5,0);
draw(Segmento,1.25bp+blue);
draw(shift(2*DespHor*dir(60))*rotate(60)*Segmento,1.25bp+blue);
draw(shift(-4*DespHor*dir(60))*rotate(-60)*Segmento,1.25bp+blue);
