//---------------------------------------------------------------
// Fichero:  solucion1.asy
// Objetivo: Representar la solución 1
// Fecha:    M.16.4.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
include fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Función que escribe un valor en un hexágono
void Escribe(path H, int F, int C)
    {
    pair T=(point(H,0)+point(H,3))/2;
    label(string(choose(F,C)),T,fontsize(20pt));
    }

// El número de líneas que vamos a generar
int n=8;

// Desplazamientos
real DespHorz=sqrt(3);
real DespVert=-1.5;

// El hexágono base
path Hexagono=rotate(30)*polygon(6);

// Las filas
real Izq=0;
for ( int Fil=0 ; Fil<n ; ++Fil )
    {
    Izq=-DespHorz*Fil/2;
    // Las columnas
    for ( int Col=0 ; Col<Fil+1 ; ++Col )
        {
        path Hex=shift(Izq,Fil*DespVert)*Hexagono;
        Escribe(Hex,Fil,Col);
        draw(Hex,black+0.5bp);
        Izq += DespHorz;
        }
    }

