//---------------------------------------------------------------
// Fichero:  log2.asy
// Objetivo: Función log2(x)
// Fecha:    L.9.12.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// graph()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Dimensiones de los ejes
real Xmin = -0.5, Xmax = 5, Ymin = -2.5, Ymax = 3;

// Grosor de las líneas
defaultpen(1);

// El eje de ordenadas
draw((0,Ymin) -- (0,Ymax), gray);

// El eje de abscisas
draw((Xmin,0) -- (Xmax,0), gray);

// La gráfica
real F(real x) { return (log(x)/log(2)); }
path Grafica=graph(F,0.2,Xmax,n=100);
draw(Grafica);

// Los puntos
real Grosor=5bp;
dot((1,0),deepgreen+Grosor);
dot((2,1),red+Grosor);
dot((4,2),blue+Grosor);
dot((0.5,-1),orange+Grosor);

// Algunas abscisas
real Abs[]={0.5, 2, 4};
real Desp=0.1;
for ( int i=0 ; i<Abs.length ; ++i )
    {
    draw((Abs[i],-Desp)--(Abs[i],Desp),gray);
    label(string(Abs[i]),(Abs[i],0),2S);
    }

// Algunas ordenadas
real Ord[]={-1, 1, 2};
real Desp=0.1;
for ( int i=0 ; i<Ord.length ; ++i )
    {
    draw((-Desp,Ord[i])--(Desp,Ord[i]),gray);
    label(string(Ord[i]),(0,Ord[i]),2W);
    }

