//---------------------------------------------------------------
// Fichero:  inversa.asy
// Objetivo: Mostrar qué hará la función inversa de la exponencial
// Fecha:    D.27.10.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// graph()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Dimensiones de los ejes
real Xmin = -4, Xmax = 4, Ymin = -0.5, Ymax = 4;

// Grosor de las líneas
defaultpen(1);

// El eje de ordenadas
draw((0,Ymin) -- (0,Ymax), black);

// El eje de abscisas
draw((Xmin,0) -- (Xmax,0), black);

// La gráfica
real F(real x) { return (1.4^x); }
path Grafica=graph(F,Xmin,Xmax,n=100);
draw(Grafica,linewidth(2bp)+blue);

// Un punto de la gráfica
dot((2,F(2)),red+4bp);

// El punto del eje de ordenadas
label("y",(0,F(2)),W);
dot((0,F(2)),deepgreen+4bp);

// El punto del eje de abscisas
label("x?",(2,0),S);
dot((2,0),deepgreen+4bp);

// Las flechas
draw((0.2,F(2)) -- (1.8,F(2)), gray, Arrow(HookHead,1.5bp));
draw((2,F(2)-0.2) -- (2,0.2), gray, Arrow(HookHead,1.5bp));
