//---------------------------------------------------------------
// Fichero:  solucion2.asy
// Objetivo: Mostrar la solución 2
// Fecha:    D.9.2.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Dimensiones de los ejes
real Xmin = -4, Xmax = 3, Ymin = -1, Ymax = 2, Extra = 0.25;

// Grosor de las líneas
defaultpen(1);

// Formato de marcas de los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(10pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra), gray);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0), gray);

// La gráfica
draw((0,2) -- (3,-1));
real F(real x) { return (0.5*x^2+2x+2); }
path Grafica=graph(F,-4,0,n=200);
draw(Grafica);

// Los puntos especiales
dot((-4,2), 5bp+black);
dot((3,-1), 5bp+black);
dot((3,-1), 3bp+white);
