//---------------------------------------------------------------
// Fichero:  ejemploplano.asy
// Objetivo: Mostrar una solución que es una parte del plano
// Fecha:    M.3.9.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3.5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los puntos
pair A=(0,0), B=(3,0), C=(4,0), D=(2,1), E=(0,3), F=(0,2);

// Dimensiones de los ejes
real Xmin = 0, Xmax = 4, Ymin = 0, Ymax = 3, Extra = 0.5;

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(6pt);

// La región
fill(A -- B -- D -- F -- cycle, gray);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// Los segmentos
pen FormatoSegmento=1pt+deepgreen;
draw(B -- E, FormatoSegmento);
draw(C -- F, FormatoSegmento);

// Los puntos
pen FormatoPunto=3pt+black;
dot(A, FormatoPunto);
dot(B, FormatoPunto);
dot(C, FormatoPunto);
dot(D, FormatoPunto);
dot(E, FormatoPunto);
dot(F, FormatoPunto);
