//---------------------------------------------------------------
// Fichero:  triangulo.asy
// Objetivo: Mostrar el triángulo crucial del problema
// Fecha:    V.6.10.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,2.5cm);

// Grosor de las líneas
defaultpen(1);

// Los puntos
pair C=(0,0), P=(4,0), A=(.25,0), T=(.25,0.97), Z=(1,0);

// Los ángulos rectos
markrightangle(T, A, Z, 2mm, 0.5bp+blue);
markrightangle(C, T, P, 3mm, 0.5bp+blue);

// La altura del triángulo
pen Punteado = linetype(new real[] {2,2});
draw(T -- A, Punteado+blue);

// El triángulo
draw(C -- P -- T -- cycle);

// Los puntos
pen FormatoPunto=2bp+red;
dot(C, FormatoPunto);
dot(P, FormatoPunto);
dot(A, FormatoPunto);
dot(T, FormatoPunto);
dot(Z, FormatoPunto);

// Los nombres
pen FormatoTexto=fontsize(10pt)+blue;
label("A", A, S, FormatoTexto);
label("C", C, W, FormatoTexto);
label("P", P, E, FormatoTexto);
label("T", T, N, FormatoTexto);
label("Z", Z, S, FormatoTexto);
label("$r$", (C+T)/2, W, FormatoTexto);
label("$h$", (A+Z)/2, N, FormatoTexto);
label("$d$", (Z+P)/2, S, FormatoTexto);
