//---------------------------------------------------------------
// Fichero:  relación.asy
// Objetivo: Mostrar semiesfera, cilindro y cono
// Fecha:    M.12.4.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// revolution()
import solids;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=10;

// Tamaño de la imagen
size(4cm);

// Punto de proyección
currentprojection=orthographic((4,0,1),Z);

// Datos de la figura plana
// He puesto 1.01 para evitar un error
real Radio=1.01, Altura=1;

// La figura plana
path3 Poli=(0,0,0)--(Radio,0,0)--(Radio,0,Altura)--(0,0,Altura);

// El cuerpo de revolución
revolution Cilindro=revolution(Poli,Z);

// Marcamos las bases
skeleton Corte;
Cilindro.transverse(Corte,reltime(Cilindro.g,0.5),P=currentprojection);
draw(shift(Altura/2*Z)*Corte.transverse.front,1bp+black);
draw(shift(-Altura/2*Z)*Corte.transverse.back,1bp+gray+linetype("2 2",8));

// Marcamos el contorno
draw(Cilindro.silhouette(),1bp+black);

// Para dibujar el cono, añadimos dos líneas
draw((0,Radio,0)--(0,0,Altura)--(0,-Radio,0),1bp+darkgreen);

// Para dibujar la semiesfera, añadimos un arco
draw((0,-Radio,0)..(0,Radio,0.04*Radio)..(0,Radio,0),1bp+darkred);

// Los tres puntos que marcamos
triple T=(0,0,0), A=(0,Radio,0), B=(0,0,Altura);;
dot(A,blue);
dot(B,blue);
dot(T,blue);

// El radio de la base de abajo
draw(A--T,1bp+blue);
label("r",(A+T)/2-0.1*Z,blue);

// La altura
draw(T--B,1bp+blue);
label("r",(T+B)/2-0.1*Y,blue);
