//---------------------------------------------------------------
// Fichero:  casquete.asy
// Objetivo: Mostrar un casquete esférico limitado por dos planos
// Fecha:    V.29.9.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// revolution()
import solids;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=6;

// Tamaño de la imagen
size(0,2.5cm);

// Punto de proyección
currentprojection=orthographic(5,4,3);

// La figura plana
real Altura=0.3;
real a=sqrt(1-Altura^2), b=-1;
path3 Arco=arc((0,0,0), (a,0,sqrt(1-a^2)), (b,0,sqrt(1-b^2)), Y);

// El cuerpo de revolución
draw(surface(revolution(Arco,Z)),lightgray);
draw(surface(circle((0,0,sqrt(1-a^2)),a)),lightgray);

// Dos planos
real Lado=2.25;
path3 Plano1=shift(-Lado/2,-Lado/2,Altura)*scale3(Lado)*unitsquare3;
path3 Plano2=shift(-Lado/2,-Lado/2,-1)*scale3(Lado)*unitsquare3;
draw(surface(Plano1),red+opacity(.1));
draw(surface(Plano2),red+opacity(.1));
draw(Plano1,0.25bp+red);
draw(Plano2,0.25bp+red);

// El círculo de corte de la esfera y los planos
draw(circle((0,0,Altura),sqrt(1-Altura^2)),red);
