//---------------------------------------------------------------
// Fichero:  relacion2D.asy
// Objetivo: Mostrar en 2D la relación en un segmento esférico
// Fecha:    L.25.9.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(4,0), C=(0,-3);

// El triángulo
draw(A -- B -- C -- cycle);

// Los textos
pen FormatoTexto=fontsize(10pt)+blue;
label("$s$", (A+B)/2, N, FormatoTexto);
label("$r$", (B+C)/2, SE, FormatoTexto);
label("$d$", (A+C)/2, W, FormatoTexto);

// El ángulo recto
markrightangle(B, A, C, 2mm, 0.5bp+blue);
