//---------------------------------------------------------------
// Fichero:  casquete1.asy
// Objetivo: Mostrar el casquete superior
// Fecha:    V.22.9.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// revolution()
import solids;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=6;

// Tamaño de la imagen
size(0,3cm);

// Punto de proyección
currentprojection=orthographic(5,4,3);

// La figura plana
real Altura=0.5;
real a=0, b=sqrt(1-Altura^2);
path3 Arco=arc((0,0,0), (a,0,sqrt(1-a^2)), (b,0,sqrt(1-b^2)), Y);

// El cuerpo de revolución
draw(surface(revolution(Arco,Z)),lightgray+opacity(.5));
draw(circle((0,0,sqrt(1-b^2)),b),1bp+black);
draw(surface(circle((0,0,sqrt(1-b^2)),b)),lightgray);

// Punto invisible
dot(-Z,white);
