//---------------------------------------------------------------
// Fichero:  trapeciocircular.asy
// Objetivo: Representar un trapecio circular
// Fecha:    L.11.9.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3cm);

// Grosor de las líneas
defaultpen(1);

// Datos auxiliares
real Ang=60;
pair A=1*dir(270-Ang), B=1*dir(270+Ang);
pair C=2*dir(270-Ang), D=2*dir(270+Ang);

// El trapecio circular
draw(arc((0,0),A,B));
draw(arc((0,0),C,D));
draw(A--C);
draw(B--D);

// Los textos
pen FormatoTexto=fontsize(8pt)+blue;
label("a",(0,-2),N,FormatoTexto);
label("b",(0,-1),N,FormatoTexto);
label("h",(B+D)/2,NE,FormatoTexto);
label("h",(A+C)/2,NW,FormatoTexto);
