//---------------------------------------------------------------
// Fichero:  trapecio.asy
// Objetivo: Mostrar la relación entre la altura, los radios
//           y la generatriz
// Fecha:    D.10.9.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,2.2cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(4,0), C=(3,3), D=(0,3);

// El trapecio
draw(A -- B -- C -- D -- cycle);

// Los textos
pen FormatoTexto=fontsize(10pt)+blue;
label("$r$", (A+B)/2, S, FormatoTexto);
label("$g$", (B+C)/2, E, FormatoTexto);
label("$s$", (C+D)/2, N, FormatoTexto);
label("$h$", (D+A)/2, W, FormatoTexto);

// Marcamos los ángulos rectos
markrightangle(C, D, A, 2mm, 0.5bp+blue);
markrightangle(D, A, B, 2mm, 0.5bp+blue);
