//---------------------------------------------------------------
// Fichero:  relacion.asy
// Objetivo: Resaltar la relación entre elementos
// Fecha:    D.10.9.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// revolution()
import solids;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=6;

// Tamaño de la imagen
size(4.3cm);

// Punto de proyección
currentprojection=orthographic((5,2,2),Z);

// Datos de la figura plana
real Radio1=3, Radio2=2, Altura=2.5;

// La figura plana
path3 Trapecio = (0,0,0) -- (Radio1,0,0) -- (Radio2,0,Altura) -- (0,0,Altura);

// El cuerpo de revolución
draw(surface(revolution(Trapecio,Z)),lightgray+opacity(.6));
draw(circle((0,0,0),Radio1),1bp+black);
draw(circle((0,0,Altura),Radio2),1bp+black);

// La relación
int Ang=70;

// Generatriz
triple A=(Radio1*cos(Ang),Radio1*sin(Ang),0);
triple B=(Radio2*cos(Ang),Radio2*sin(Ang),Altura);
dot(A, 3bp+black);
dot(B, 3bp+black);
draw(A -- B, 2bp+red);

// Los radios
triple A=(0,0,0), B=(Radio1*cos(Ang),Radio1*sin(Ang),0);
dot(A, 3bp+black);
dot(B, 3bp+black);
draw(A -- B, 2bp+red);
triple A=Altura*Z, B=(Radio2*cos(Ang),Radio2*sin(Ang),Altura);
dot(A, 3bp+black);
dot(B, 3bp+black);
draw(A -- B, 2bp+red);

// La altura
triple A=(0,0,0), B=(0,0,Altura);
dot(A, 3bp+black);
dot(B, 3bp+black);
draw(A -- B, 2bp+red);
