//---------------------------------------------------------------
// Fichero:  triangulos-2D.asy
// Objetivo: Mostrar en 2D los dos triángulos
// Fecha:    M.12.9.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,2.2cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(12,0), C=(0,9);

// El triángulo
draw(A -- B -- C -- cycle);

// La apotema corta
pair D=(0,3), E1=(8,3);
draw(D -- E1);

// Los textos
pen FormatoTexto=fontsize(8pt)+blue;
label("$3$", (A+D)/2, W, FormatoTexto);
label("$8$", (D+E1)/2, S, FormatoTexto);
label("$x$", (D+C)/2, W, FormatoTexto);
label("$12$", (A+B)/2, S, FormatoTexto);

// Marcamos el punto de división
dot(D,2bp+red);

// Marcamos los ángulos rectos
markrightangle(C, A, B, 2mm, 0.5bp+blue);
markrightangle(C, D, E1, 2mm, 0.5bp+blue);
