//---------------------------------------------------------------
// Fichero:  triangulo.asy
// Objetivo: Dibujar un triángulo rectángulo
// Fecha:    X.30.8.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Grosor de las líneas
defaultpen(1);

// Los vértices
pair A=dir(110), B=(-1,0), C=(1,0);

// El triángulo
draw(A -- B -- C -- cycle);

// Los ángulos
pen FormatoAngulo = 0.5bp+blue;
markrightangle(B, A, C, 3mm, FormatoAngulo);

// Los lados
pen FormatoTexto=10pt+blue;
label("a",(0,0),S,FormatoTexto);
label("b",(A+C)/2,NE,FormatoTexto);
label("c",(A+B)/2,NW,FormatoTexto);

// Los puntos
pen FormatoPunto=3bp+red;
dot(A,FormatoPunto);
dot(B,FormatoPunto);
dot(C,FormatoPunto);
label("A", A, N, FormatoTexto);
label("B", B, W, FormatoTexto);
label("C", C, E, FormatoTexto);
