//---------------------------------------------------------------
// Fichero:  resolucion1.asy
// Objetivo: Dibujar la resolución 1
// Fecha:    V.28.7.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// Los vértices
pair A=(0,0), B=(20,0), C=(0,17);

// El triángulo grande
draw(A -- B -- C -- cycle);

// El triángulo pequeño
pair D=(0,11), F=(7,11);
draw(D -- F);

// Los ángulos
pen FormatoAngulo = 0.5bp+blue;
markrightangle(C, A, B, 3mm, FormatoAngulo);
markrightangle(C, D, F, 3mm, FormatoAngulo);

// Los lados
pen FormatoLado=10pt+blue;
label("20",(10,0),S,FormatoLado);
label("7",(3.5,11),S,FormatoLado);
label("11",(0,5.5),W,FormatoLado);
label("x",(0,14),W,FormatoLado);

// Los vértices
pen FormatoVertice=black+fontsize(10pt)+Helvetica(series="b",shape="n");
label("A",A,SW,FormatoVertice);
label("B",B,SE,FormatoVertice);
label("C",C,N,FormatoVertice);
label("D",D,W,FormatoVertice);
label("E",F,NE,FormatoVertice);

// Los puntos
pen FormatoPunto=3bp+red;
dot(A,FormatoPunto);
dot(B,FormatoPunto);
dot(C,FormatoPunto);
dot(D,FormatoPunto);
dot(F,FormatoPunto);
