//---------------------------------------------------------------
// Fichero:  sombras.asy
// Objetivo: Dibujar dos objetos con sombras
// Fecha:    X.26.7.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(12cm);

// Grosor de las líneas
defaultpen(1);

// Formatos
pen FormatoTexto = fontsize(10pt)+blue+Helvetica(series="m",shape="n");
pen FormatoRayo = 3bp+lightolive;
pen FormatoObjeto = 5bp+black+linecap(1);
pen FormatoSombra = 3bp+gray;

// Primer objeto
draw((-3,11.67) -- (18,0), FormatoRayo);
draw((0,0) -- (18,0), FormatoSombra);
draw((0,0) -- (0,10), FormatoObjeto);
label("Objeto 1", (0,5), 2W, FormatoTexto);
label("Rayo", (-3,11.67), 2N, FormatoTexto);
label("Sombra 1", (9,0), 2S, FormatoTexto);

// Segundo objeto
draw((31,8.67) -- (46.6,0), FormatoRayo);
draw((34,0) -- (46.6,0), FormatoSombra);
draw((34,0) -- (34,7), FormatoObjeto);
label("Objeto 2", (34,3.5), 2W, FormatoTexto);
label("Rayo", (31,8.67), 2N, FormatoTexto);
label("Sombra 2", (40.3,0), 2S, FormatoTexto);
