//---------------------------------------------------------------
// Fichero:  ejemplo3.asy
// Objetivo: Ilustrar el ejemplo3
// Fecha:    D.16.7.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
include fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.8cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve el baricentro de un triángulo
pair Bar(pair P1, pair P2, pair P3)
    { return (P1+P2+P3)/3; }

// Los vértices
pair A=(0,0), B=(5,-3), C=(12,-2), D=(15,1), E=(10,5), F=(3,3);

// Los triángulos
draw(F -- B, gray);
draw(F -- C, gray);
draw(F -- D, gray);

// El polígono
draw(A -- B -- C -- D -- E -- F -- cycle);

// Los nombres de los triángulos
label("T1",Bar(A,B,F),blue+fontsize(10pt));
label("T2",Bar(F,B,C),blue+fontsize(10pt));
label("T3",Bar(F,C,D),blue+fontsize(10pt));
label("T4",Bar(F,D,E),blue+fontsize(10pt));
