//---------------------------------------------------------------
// Fichero:  ejemplo1.asy
// Objetivo: Ilustrar el ejemplo1
// Fecha:    D.16.7.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
include fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.8cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve el baricentro de un triángulo
pair Bar(pair P1, pair P2, pair P3)
    { return (P1+P2+P3)/3; }

// Los vértices
pair A=(0,0), B=(8,-4), C=(13,1), D=(4,4);

// Los triángulos
draw(A -- C, gray);

// El polígono
draw(A -- B -- C -- D -- cycle);

// Los nombres de los triángulos
label("T1",Bar(A,D,C),blue+fontsize(10pt));
label("T2",Bar(A,B,C),blue+fontsize(10pt));
