//---------------------------------------------------------------
// Fichero:  triangulos2.asy
// Objetivo: Dibujar dos triángulos en posición de Tales
//           con rectas paralelas
// Fecha:    L.10.7.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
include fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve el punto medio de un segmento
pair Med(pair P1, pair P2)
    { return (P1+P2)/2; }

// Los cuatro puntos más bajos
pair A=(0,0), B=(9,0), C=(7,2), E1=(0.75,2);

// El quinto punto
pair D=intersectionpoint(A--A+5*(E1-A), B--B+5(C-B));

// Las rectas paralelas
pen Punteado = gray+linetype(new real[] {2,2});
draw((-2,0) -- (11,0), Punteado);
draw((-2,2) -- (11,2), Punteado);
draw((-2,D.y) -- (11,D.y), Punteado);
label("$p_3$",(-2,0),W,fontsize(8pt));
label("$p_2$",(-2,2),W,fontsize(8pt));
label("$p_1$",(-2,D.y),W,fontsize(8pt));

// Los triángulos
draw(A -- B -- D -- cycle);
draw(E1 -- C, blue);

// Los puntos
pen Formato=2bp+red;
dot(A,2bp+Formato);
dot(B,2bp+Formato);
dot(C,2bp+Formato);
dot(D,2bp+Formato);
dot(E1,2bp+Formato);

// Los nombres de los vértices
pen Formato=black+fontsize(8pt);
label("B",A,SW,Formato);
label("C",B,SE,Formato);
label("E",C,NE,Formato);
label("A",D,N,Formato);
label("D",E1,NW,Formato);
