//---------------------------------------------------------------
// Fichero:  enunciado1.asy
// Objetivo: Dibujar el enunciado 1
// Fecha:    S.8.7.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
include fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3.5cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve el punto medio de un segmento
pair Med(pair P1, pair P2)
    { return (P1+P2)/2; }

// Función que devuelve un vector normal a un segmento
pair Normal(pair P1, pair P2)
    {
    pair Vector=unit(P2-P1);
    return (Vector.y,-Vector.x);
    }

// El triángulo pequeño
pair P=(0,0), S=(6,1), T=(2,3);

// El triángulo grande
pair Q=scale(1.4)*S;
pair R=scale(1.4)*T;

// Dibujamos los triángulos
draw(P -- Q -- R -- cycle);
draw(S -- T);

// Los puntos
pen Formato=2bp+red;
dot(P,2bp+Formato);
dot(Q,2bp+Formato);
dot(R,2bp+Formato);
dot(S,2bp+Formato);
dot(T,2bp+Formato);

// Las líneas auxiliares
real delta=0.2;
pen Formato=gray+0.2mm;
pair v=delta*Normal(P,R);
draw(P-v -- R-v,Formato);
pair Direccion=T-P;
draw(P+v+0.1*Direccion -- T+v-0.05*Direccion,Formato);
pair v=delta*Normal(Q,R);
draw(Q+v -- R+v,Formato);
pair Direccion=T-S;
draw(S-v+0.1*Direccion -- T-v-0.07*Direccion,Formato);

// Los nombres de los vértices
pen Formato=black+fontsize(6pt);
label("P",P,SW,Formato);
label("Q",Q,E,Formato);
label("R",R,1.5N,Formato);
label("S",S,1.5N+0.5E,Formato);
label("T",T,2E+0.5N,Formato);

// Las longitudes de los lados
pen Formato=black+fontsize(4pt);
label("4,62",Med(P,R),2NW,Formato);
label("3,3",Med(P,T),3E,Formato);
label("x",Med(R,Q),3NE,Formato);
label("4.5",Med(T,S),3SW,Formato);
