//---------------------------------------------------------------
// Fichero:  circulos.asy
// Objetivo: Dibujar dos círculos semejantes
// Fecha:    L.26.6.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(10cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve el punto medio de un segmento
pair Med(pair P1, pair P2)
    { return (P1+P2)/2; }

// El primer círculo
pair T1=(0,0), P1=dir(45);
draw(circle(T1,1));
dot(T1,4bp+black); dot(P1,4bp+black);
draw(T1 -- P1);

// El segundo círculo
transform F=shift(2.5,0)*scale(1.25);
pair T2=F*T1, P2=F*P1;
draw(F*circle(T1,1));
dot(T2,4bp+black); dot(P2,4bp+black);
draw(T2 -- P2);

// Las longitudes de los radios
pen Formato=blue+fontsize(16pt);
label("s",Med(T1,P1),NW,Formato);
label("t",Med(T2,P2),NW,Formato);

// Los nombres de los círculos
label("C",T1,5S,Formato);
label("D",T2,5S,Formato);
