//---------------------------------------------------------------
// Fichero:  triangulos.asy
// Objetivo: Dibujar dos triángulos semejantes
// Fecha:    D.25.6.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(12cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve el punto medio de un segmento
pair Med(pair P1, pair P2)
    { return (P1+P2)/2; }

// Función que devuelve el baricentro de un triángulo
pair Bar(pair P1, pair P2, pair P3)
    { return (P1+P2+P3)/3; }

// Las longitudes de los lados
real a=7, b=5, c=4;

// La razón de semejanza
real r=1.2;

// El desplazamiento
real d=9;

// Las posiciones de las etiquetas
pair Pos[]={S,NW,NE};

// El triángulo básico
pair A=(0,0), B=(a,0);
pair C=intersectionpoint(circle(A,b), circle(B,c));
pair Baricentro=Bar(A,B,C);

// El primer triángulo
pair A1=A, B1=B, C1=C;
draw(A1 -- B1 -- C1 -- cycle);

// El segundo triángulo
transform F=shift(d,0)*scale(r);
pair A2=F*A, B2=F*B, C2=F*C;
draw(A2 -- B2 -- C2 -- cycle);

// Las longitudes de los lados
pen Formato=blue+fontsize(16pt);
label("a",Med(A1,B1),Pos[0],Formato);
label("b",Med(A1,C1),Pos[1],Formato);
label("c",Med(B1,C1),Pos[2],Formato);
label("a'",Med(A2,B2),Pos[0],Formato);
label("b'",Med(A2,C2),Pos[1],Formato);
label("c'",Med(B2,C2),Pos[2],Formato);

// Los nombres de los triángulos
label("T",Bar(A1,B1,C1),Formato);
label("T'",Bar(A2,B2,C2),Formato);
