//---------------------------------------------------------------
// Fichero:  ejemplo1.asy
// Objetivo: Dibujar dos triángulos semejantes
// Fecha:    D.25.6.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(10cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve el punto medio de un segmento
pair Med(pair P1, pair P2)
    { return (P1+P2)/2; }

// Función que devuelve el baricentro de un triángulo
pair Bar(pair P1, pair P2, pair P3)
    { return (P1+P2+P3)/3; }

// Función que devuelve una cadena a partir de un número usando
// como separador decimal la coma en vez del punto
string Conv(real Num)
    { return replace(string(Num),".",","); }

// Las longitudes de los lados
real a=7, b=5, c=4;

// Los dos giros de los triángulos
real g1=40, g2=160;

// La razón de semejanza
real r=1.4;

// El desplazamiento
real d=7;

// Las posiciones de las etiquetas
pair Pos[]={SE,NW,N,NE,S,W};

// El triángulo básico
pair A=(0,0), B=(a,0);
pair C=intersectionpoint(circle(A,b), circle(B,c));
pair Baricentro=Bar(A,B,C);

// El primer triángulo
transform G1=rotate(g1,Baricentro);
pair A1=G1*A, B1=G1*B, C1=G1*C;
draw(A1 -- B1 -- C1 -- cycle);
pair Bar1=Bar(A1,B1,C1);

// El segundo triángulo
transform G2=scale(r)*rotate(g2,Baricentro);
pair A2=G2*A, B2=G2*B, C2=G2*C;
pair Bar2=Bar(A2,B2,C2);
transform F=shift(d,Bar1.y-Bar2.y);
pair A2=F*A2, B2=F*B2, C2=F*C2;
draw(A2 -- B2 -- C2 -- cycle);

// Las longitudes de los lados
pen Formato=blue+fontsize(16pt);
label(string(a),Med(A1,B1),Pos[0],Formato);
label(string(b),Med(A1,C1),Pos[1],Formato);
label(string(c),Med(B1,C1),Pos[2],Formato);
label(Conv(r*a),Med(A2,B2),Pos[3],Formato);
label(Conv(r*b),Med(A2,C2),Pos[4],Formato);
label(Conv(r*c),Med(B2,C2),Pos[5],Formato);

// Los nombres de los triángulos
label("T",Bar1,Formato);
label("S",Bar(A2,B2,C2),Formato);
