//---------------------------------------------------------------
// Fichero:  ejemplo2a.asy
// Objetivo: Dibujar dos pirámides semejantes
// Fecha:    J.15.6.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Geometría 3D
import three;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=6;

// Tamaño de la imagen
size(6cm);

// Punto de proyección
currentprojection=orthographic(5,4,3);

// Punto de luz
currentlight=light(10,0,10);

// Número de vértices de la base
int N=4;

// La base es un polígono regular
path3 PoligonoBase = path3(rotate(-30)*polygon(N));

// El vértice superior
triple V=(0,0,0.7);

// Las caras del poliedro
path3[] Caras={PoligonoBase};
for (int i=0; i<N; ++i)
    { Caras.push(point(PoligonoBase,i)--point(PoligonoBase,i+1)--V--cycle); }

// Dibujamos las caras
draw(surface(Caras),lightgray+opacity(.5));

// Dibujamos las aristas
draw(Caras,1.5bp+black);

// El centro de la base
triple Centro=(0,0,0);

// Los puntos medios de dos aristas de la base
triple M=(point(PoligonoBase,0)+point(PoligonoBase,1))/2;
triple N=(point(PoligonoBase,1)+point(PoligonoBase,2))/2;

// La altura
draw(Centro--V,2bp+red);

// La apotema de la base
draw(M--V,2bp+red);

// Los puntos
dot(Centro,4bp+black);
dot(M,4bp+black);
dot(V,4bp+black);
dot(point(PoligonoBase,1),4bp+black);
dot(point(PoligonoBase,2),4bp+black);

// Los textos
pen Formato=Helvetica(series="m",shape="n")+fontsize(4mm)+black;
label("h",Centro+0.5*(V-Centro)/2-0.1*X,Formato);
label("m",M+0.3*(V-M)/2+0.15*Z,Formato);
label("a",N+0.1*(N-Centro)+0.1*Y,Formato);
