//---------------------------------------------------------------
// Fichero:  triangulo.asy
// Objetivo: Dibujar el problema del triángulo
// Fecha:    S.2.9.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3cm);

// Grosor de las líneas
defaultpen(1);

// Los vértices
pair A=(0,0), B=(30.875,0), C=(30.875,13);

// El triángulo grande
draw(A -- B -- C -- cycle);

// El triángulo pequeño
pair D=(19,0), F=(19,8);
draw(D -- F);

// Los ángulos
pen FormatoAngulo = 0.5bp+blue;
markrightangle(A, B, C, 3mm, FormatoAngulo);
markrightangle(A, D, F, 3mm, FormatoAngulo);

// Los lados
pen FormatoLado=10pt+blue;
label("19",(A+D)/2,S,FormatoLado);
label("x",(D+B)/2,S,FormatoLado);
label("8",(D+F)/2,E,FormatoLado);
label("13",(B+C)/2,E,FormatoLado);

// Los puntos
pen FormatoPunto=3bp+red;
dot(A,FormatoPunto);
dot(B,FormatoPunto);
dot(C,FormatoPunto);
dot(D,FormatoPunto);
dot(F,FormatoPunto);
