//---------------------------------------------------------------
// Fichero:  cuadrado.asy
// Objetivo: Dibujar el problema del cuadrado
// Fecha:    S.2.9.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,2.5cm);

// Grosor de las líneas
defaultpen(1);

// El cuadrado
real Long=3.881;
draw(box((0,0),(Long,Long)));

// El triángulo
pair A=(Long,0), B=(0.7276,Long), C=(0,Long/4);
draw(A -- B -- C -- cycle);

// Las longitudes
pen FormatoTexto=fontsize(12)+blue;
label("5", (A+B)/2, NE, FormatoTexto);
label("3", (B+C)/2, SE, FormatoTexto);
label("4", (A+C)/2, N, FormatoTexto);
