//---------------------------------------------------------------
// Fichero:  enunciado6.asy
// Objetivo: Dibujar el enunciado 6
// Fecha:    M.25.7.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3.5cm);

// Grosor de las líneas
defaultpen(1);

// Los formatos
pen FormatoTexto=blue+fontsize(8pt);

// Función que devuelve el punto medio de un segmento
pair Med(pair P1, pair P2)
    { return (P1+P2)/2; }

// Función que devuelve como cadena la distancia redondeada entre dos puntos
string Dist(pair A, pair B)
    {
    real Longitud=(round(10*length(A-B)))/10;
    return replace(string(Longitud),".",",");
    }

// Función que devuelve un vector normal a un segmento
pair Normal(pair P1, pair P2)
    {
    pair Vector=unit(P2-P1);
    return (Vector.y,-Vector.x);
    }

// Función que devuelve el producto escalar de dos vectores
real PE(pair z, pair w)
    { return z.x*w.y-z.y*w.x; }

// Función que da un segmento entre dos puntos opuesto a un tercero
void Segmento(pair A, pair B, pair C)
    {
    pair v=Normal(A,B);
    pair D=Med(A,B)+v;
    if ( sgn(PE(A-C,B-C)) == sgn(PE(A-D,B-D)) )
        { v=-v; }
    string Texto=Dist(A,B);
    label(Texto,Med(A,B),v,FormatoTexto);
    }

// Los puntos
pair A=(0,0), B=(14,0), C=(5,12);

// Las líneas
draw(A -- B -- C -- cycle);
draw(box((2.69,0),(9.15,6.46)));

// Los segmentos
Segmento(A,B,C);
Segmento(B,C,A);
Segmento(A,C,B);
