//---------------------------------------------------------------
// Fichero:  enunciado05.asy
// Objetivo: Dibujar el enunciado 05
// Fecha:    V.14.7.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
include fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(7.8cm);

// Grosor de las líneas
defaultpen(1);

// La distancia para las líneas auxiliares
real delta=0.4;

// Los formatos
pen FormatoLinea=blue+0.2mm;
pen FormatoTexto=black+fontsize(8pt);

// Función que devuelve el punto medio de un segmento
pair Med(pair P1, pair P2)
    { return (P1+P2)/2; }

// Función que devuelve un vector normal a un segmento
pair Normal(pair P1, pair P2)
    {
    pair Vector=unit(P2-P1);
    return (Vector.y,-Vector.x);
    }

// Función que devuelve como cadena la distancia redondeada entre dos puntos
string Dist(pair A, pair B)
    {
    real Longitud=(round(10*length(A-B)))/10;
    return replace(string(Longitud),".",",");
    }

// Función que dibuja un dato entre dos puntos
void Dato(pair A, pair B, int Sentido, real Ajuste, string Texto)
    {
    Ajuste /= 100;
    pair v=Sentido*delta*Normal(A,B);
    pair Direccion=B-A;
    draw(A+v+Ajuste*Direccion -- B+v-Ajuste*Direccion,FormatoLinea);
    if ( length(Texto)==0 ) { Texto=Dist(A,B); }
    label(Texto,Med(A,B),6v,FormatoTexto);
    }

// Tres rectas paralelas
pair A1=(0,0), A2=(2,15);
pair B1=(7.2,0), B2=(9.2,15);
pair C1=(20,0), C2=(22,15);
draw(A1 -- A2);
draw(B1 -- B2);
draw(C1 -- C2);

// Dos rectas oblicuas
pair D1=(-1,1), D2=(22,1);
pair E1=(-1,4), E2=(22,7);
draw(D1 -- D2);
draw(E1 -- E2);

// Puntos de corte
pair P1=intersectionpoint(A1--A2,D1--D2);
pair P2=intersectionpoint(A1--A2,E1--E2);
pair Q1=intersectionpoint(B1--B2,D1--D2);
pair Q2=intersectionpoint(B1--B2,E1--E2);
pair R1=intersectionpoint(C1--C2,D1--D2);
pair R2=intersectionpoint(C1--C2,E1--E2);

// Otras dos rectas paralelas
pair S=intersectionpoint(Q2--Q2+20*(3,1.4),C1--C2);
pair T=intersectionpoint(P2--P2+20*(3,1.4),C1--C2);
draw(Q2 -- S);
draw(P2 -- T);

// Los puntos
pen Formato=2bp+red;
dot(P1,2bp+Formato);
dot(P2,2bp+Formato);
dot(Q1,2bp+Formato);
dot(Q2,2bp+Formato);
dot(R1,2bp+Formato);
dot(R2,2bp+Formato);
dot(S,2bp+Formato);
dot(T,2bp+Formato);

// Los lados del problema
Dato(P1,Q1,1,5,"");
Dato(Q1,R1,1,3,"");
Dato(P2,Q2,1,5,"");
Dato(R2,S,1,7,"");
Dato(S,T,1,5,"x");
