//---------------------------------------------------------------
// Fichero:  enunciado04.asy
// Objetivo: Dibujar el enunciado 04
// Fecha:    V.14.7.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
include fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(7.8cm);

// Grosor de las líneas
defaultpen(1);

// La distancia para las líneas auxiliares
real delta=0.45;

// Los formatos
pen FormatoLinea=blue+0.2mm;
pen FormatoTexto=black+fontsize(8pt);

// Función que devuelve el punto medio de un segmento
pair Med(pair P1, pair P2)
    { return (P1+P2)/2; }

// Función que devuelve un vector normal a un segmento
pair Normal(pair P1, pair P2)
    {
    pair Vector=unit(P2-P1);
    return (Vector.y,-Vector.x);
    }

// Función que devuelve como cadena la distancia redondeada entre dos puntos
string Dist(pair A, pair B)
    {
    real Longitud=(round(10*length(A-B)))/10;
    return replace(string(Longitud),".",",");
    }

// Función que dibuja un dato entre dos puntos
void Dato(pair A, pair B, int Sentido, real Ajuste, string Texto)
    {
    Ajuste /= 100;
    pair v=Sentido*delta*Normal(A,B);
    pair Direccion=B-A;
    draw(A+v+Ajuste*Direccion -- B+v-Ajuste*Direccion,FormatoLinea);
    if ( length(Texto)==0 ) { Texto=Dist(A,B); }
    label(Texto,Med(A,B),5v,FormatoTexto);
    }

// La diagonal
pair A=(0,0), B=(30,3);

// Los vértices superior e inferior
pair C=(12,11), D=(28,-8);

// El triángulo pequeño superior
pair P=C+0.45*(A-C);
pair Q=C+0.45*(B-C);

// El triángulo pequeño inferior
pair R=D+0.3*(A-D);
pair S=D+0.3*(B-D);

// Dibujamos la figura
draw(A -- C -- B -- D -- cycle);
draw(A -- B);
draw(P -- Q);
draw(R -- S);

// Los puntos
pen Formato=2bp+red;
dot(A,2bp+Formato);
dot(B,2bp+Formato);
dot(C,2bp+Formato);
dot(D,2bp+Formato);
dot(P,2bp+Formato);
dot(Q,2bp+Formato);
dot(R,2bp+Formato);
dot(S,2bp+Formato);

// Los lados del problema
Dato(A,C,-1,0,"");
Dato(P,C,1,12,"");
Dato(P,Q,1,0,"");
Dato(A,D,1,0,"");
Dato(A,R,-1,8,"");
Dato(R,S,-1,3,"x");
