//---------------------------------------------------------------
// Fichero:  enunciado02.asy
// Objetivo: Dibujar el enunciado 02
// Fecha:    V.14.7.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
include fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(7.8cm);

// Grosor de las líneas
defaultpen(1);

// La distancia para las líneas auxiliares
real delta=0.4;

// Los formatos
pen FormatoLinea=blue+0.2mm;
pen FormatoTexto=black+fontsize(6pt);

// Función que devuelve el punto medio de un segmento
pair Med(pair P1, pair P2)
    { return (P1+P2)/2; }

// Función que devuelve un vector normal a un segmento
pair Normal(pair P1, pair P2)
    {
    pair Vector=unit(P2-P1);
    return (Vector.y,-Vector.x);
    }

// Función que devuelve como cadena la distancia redondeada entre dos puntos
string Dist(pair A, pair B)
    {
    real Longitud=(round(10*length(A-B)))/10;
    return replace(string(Longitud),".",",");
    }

// Función que dibuja un dato entre dos puntos
void Dato(pair A, pair B, int Sentido, real Ajuste, string Texto)
    {
    Ajuste /= 100;
    pair v=Sentido*delta*Normal(A,B);
    pair Direccion=B-A;
    draw(A+v+Ajuste*Direccion -- B+v-Ajuste*Direccion,FormatoLinea);
    if ( length(Texto)==0 ) { Texto=Dist(A,B); }
    label(Texto,Med(A,B),6v,FormatoTexto);
    }

// El triángulo pequeño
pair A=(0,0), B=(-8,-7), C=(12,-8);

// El triángulo grande
pair L=scale(1.9)*B;
pair M=scale(1.9)*C;

// Dibujamos los triángulos
draw(A -- L -- M -- cycle);
draw(B -- C);

// Los puntos
pen Formato=2bp+red;
dot(A,2bp+Formato);
dot(B,2bp+Formato);
dot(C,2bp+Formato);
dot(L,2bp+Formato);
dot(M,2bp+Formato);

// Los lados del problema
Dato(A,B,1,5,"");
Dato(A,M,-1,2.5,"");
Dato(C,M,1,10,"");
Dato(B,L,1,2.5,"x");
