//---------------------------------------------------------------
// Fichero:  enunciado07.asy
// Objetivo: Dibujar el enunciado 7
// Fecha:    V.1.9.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.8cm);

// Grosor de las líneas
defaultpen(1);

//----------- Los datos de este enunciado

// El ángulo para obtener el vértice del ángulo recto
int Ang=43;

// Ángulo de giro del triángulo
int Giro=0;

// La escala para multiplicar los valores
real Escala=4.29;

// Los formatos
pen FormatoSegmento=blue+fontsize(8pt);
pen FormatoPunto=3bp+red;

//----------- Fin de los datos

// Función que devuelve el punto medio de un segmento
pair Med(pair P1, pair P2)
    { return (P1+P2)/2; }

// Función que devuelve como cadena la distancia redondeada entre dos puntos
string Dist(pair A, pair B)
    {
    real Longitud=(round(10*Escala*length(A-B)))/10;
    return replace(string(Longitud),".",",");
    }

// Función que devuelve un vector normal a un segmento
pair Normal(pair P1, pair P2)
    {
    pair Vector=unit(P2-P1);
    return (Vector.y,-Vector.x);
    }

// Función que devuelve el producto escalar de dos vectores
real PE(pair z, pair w)
    { return z.x*w.y-z.y*w.x; }

// Función que da un segmento entre dos puntos opuesto a una posición
void Segmento(pair A, pair B, pair C, bool Incognita)
    {
    pair v=Normal(A,B);
    pair D=Med(A,B)+v;
    if ( sgn(PE(A-C,B-C)) == sgn(PE(A-D,B-D)) )
        { v=-v; }
    string Texto=Dist(A,B);
    if ( Incognita ) { Texto="x"; }
    label(Texto,Med(A,B),v,FormatoSegmento);
    }

// Los vértices del triángulo
pair A=dir(Ang), B=(-1,0), C=(1,0);

// La proyección del vértice sobre la hipotenusa
pair Q=(A.x,0);

// Giramos todo
A=rotate(Giro)*A;
B=rotate(Giro)*B;
C=rotate(Giro)*C;
Q=rotate(Giro)*Q;

// El triángulo
draw(A -- Q, blue);
draw(A -- B -- C -- cycle);

// Los puntos
dot(A,FormatoPunto);
dot(B,FormatoPunto);
dot(C,FormatoPunto);
dot(Q,FormatoPunto);

// Los segmentos
Segmento(B,Q,A,false);
Segmento(Q,C,A,false);
Segmento(A,C,B,true);
