//---------------------------------------------------------------
// Fichero:  enunciado14.asy
// Objetivo: Dibujar el enunciado 14
// Fecha:    L.10.7.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
include fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.8cm);

// Grosor de las líneas
defaultpen(1);

// La distancia para las líneas auxiliares
real delta=0.6;

// Los formatos
pen FormatoLinea=blue+0.2mm;
pen FormatoTexto=black+fontsize(8pt);

// Función que devuelve el punto medio de un segmento
pair Med(pair P1, pair P2)
    { return (P1+P2)/2; }

// Función que devuelve un vector normal a un segmento
pair Normal(pair P1, pair P2)
    {
    pair Vector=unit(P2-P1);
    return (Vector.y,-Vector.x);
    }

// Función que devuelve como cadena la distancia redondeada entre dos puntos
string Dist(pair A, pair B)
    {
    real Longitud=(round(10*length(A-B)))/10;
    return replace(string(Longitud),".",",");
    }

// Función que dibuja un dato entre dos puntos
void Dato(pair A, pair B, int Sentido, real Ajuste, bool Incognita)
    {
    pair v=Sentido*delta*Normal(A,B);
    pair Direccion=B-A;
    draw(A+v+Ajuste*Direccion -- B+v-Ajuste*Direccion,FormatoLinea);
    string Texto=Dist(A,B);
    if ( Incognita ) { Texto="x"; }
    label(Texto,Med(A,B),4v,FormatoTexto);
    }

// La recta de arriba
pair A=(-1,45), B=(52,35);
path Izq=A -- B;
draw(Izq);

// La recta de abajo
pair C=(-1,9), D=(52,21);
path Der=C -- D;
draw(Der);

// Las rectas paralelas
path r1=(0,0) -- (3,50);
path r2=(22,0) -- (25,50);
path r3=(45,0) -- (48,50);
draw(r1);
draw(r2);
draw(r3);

// Los puntos de corte entre las rectas
pair P1=intersectionpoint(Izq,r1);
pair P2=intersectionpoint(Izq,r2);
pair P3=intersectionpoint(Izq,r3);
pair Q1=intersectionpoint(Der,r1);
pair Q2=intersectionpoint(Der,r2);
pair Q3=intersectionpoint(Der,r3);
pen Formato=2bp+red;
dot(P1,Formato);
dot(P2,Formato);
dot(P3,Formato);
dot(Q1,Formato);
dot(Q2,Formato);
dot(Q3,Formato);

// Los segmentos del problema
Dato(P1,P2,-1,0.03,false);
Dato(P2,P3,-1,0.03,false);
Dato(Q2,Q3,1,0.03,false);
Dato(Q1,Q2,1,0.05,true);
