//---------------------------------------------------------------
// Fichero:  enunciado12.asy
// Objetivo: Dibujar el enunciado 12
// Fecha:    S.17.6.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.8cm);

// Grosor de las líneas
defaultpen(1);

// La figura original
pair V[]={(0,0), (3,0), (3,2), (2,3), (0,3)};
guide Original;
for ( int i=0 ; i<V.length ; ++i )
    { Original = Original -- V[i]; }
Original = Original -- cycle;

// La transformación
transform F=shift(3.5,-0.3)*scale(1.2)*rotate(180,(1.5,1.5));

// La figura nueva
pair V[]={(0,0), (3,0), (3,1), (1,3), (0,3)};
guide Nueva;
for ( int i=0 ; i<V.length ; ++i )
    { Nueva = Nueva -- V[i]; }
Nueva = Nueva -- cycle;

// Dibujamos
draw(Original);
draw(F*Nueva);

