#!/usr/bin/python
# coding: utf-8

#--------------------------------------------------------------------
# Fichero:  piramide.py
# Objetivo: Da el área y el volumen de la pirámide
# Autor:    Pedro Reina <pedro@pedroreina.net>
# Fecha:    S.20.5.2023
# Atención: solo se ha probado en Python 2.7
# Licencia: Dominio público
#           https://creativecommons.org/publicdomain/zero/1.0/
#--------------------------------------------------------------------

#------------------------------------------------
# Módulos
#------------------------------------------------

# Para leer la línea de órdenes
import sys

# sqrt()
import math

#------------------------------------------------
# Funciones
#------------------------------------------------

#------------------------------------------------
# Calcula un cateto a partir de la hipotenusa y el otro cateto
def Cateto(a,b):
    return math.sqrt(a**2-b**2)

#------------------------------------------------
# El programa
#------------------------------------------------

# Leemos los datos de la línea de órdenes
Lado = float(sys.argv[1])
Arista = float(sys.argv[2])

# Mostramos los datos
print 'Lado de la base:', Lado
print 'Arista lateral:', Arista

# La altura de la base
AlturaBase = Lado*math.sqrt(3)/2

# El área de la base
AreaBase = Lado*AlturaBase/2

# La apotema de la pirámide
Apotema = Cateto(Arista,AlturaBase/3)

# El área
Area = AreaBase + 3*Lado*Apotema/2

# La altura de la pirámide
AlturaPiramide = Cateto(Arista,2*AlturaBase/3)

# El volumen
Volumen = AreaBase*AlturaPiramide/3

# Mostramos el resultado
print 'Área:', Area
print 'Volumen:', Volumen
