//---------------------------------------------------------------
// Fichero:  interiores.asy
// Objetivo: Dibujar los segmentos tangentes interiores a dos
//           circunferencias exteriores
// Fecha:    L.8.5.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3.5cm);

// Grosor de las líneas
defaultpen(1);

// Centros y los radios de las dos circunferencias
pair T1=(0,0), T2=(4,0);
real R1=1, R2=1.8;

// Las circunferencias
path C1=circle(T1,R1); draw(C1);
path C2=circle(T2,R2); draw(C2);

// Los centros
dot(T1,2bp+black);
dot(T2,2bp+black);

// Circunferencia auxiliar de centro T2 y radio R1+R2
path Exterior=circle(T2,R1+R2);

// Circunferencia auxiliar de diámetro T1--T2
path Diametral=circle((T1+T2)/2,length(T1-T2)/2);

// El punto de corte superior de las dos circunferencias auxiliares
pair Aux=intersectionpoint(Exterior,Diametral);

// Los primeros puntos de tangencia
pair G2=intersectionpoint(C2, T2--(T2+(R2+1)*(Aux-T2)));
pair G1=intersectionpoint(C1, T1--(T1+(R1+1)*(T2-Aux)));

// Los segundos puntos de tangencia
pair H1=(G1.x,-G1.y);
pair H2=(G2.x,-G2.y);

// Los segmentos tangentes
draw(G1--G2,blue);
draw(H1--H2,blue);

// Los puntos de tangencia
dot(G1,2bp+red);
dot(G2,2bp+red);
dot(H1,2bp+red);
dot(H2,2bp+red);
